<?php
header('Content-Type: application/json; charset=utf-8');
$db = new PDO("sqlite:db.sqlite");

// 1. Zugangsdaten aus dem Request holen
$user = $_GET['username'] ?? '';
$pass = $_GET['password'] ?? '';
$action = $_GET['action'] ?? 'login';

// 2. Benutzer aus der Datenbank laden
$stmt = $db->prepare("SELECT * FROM users WHERE username=?");
$stmt->execute([$user]);
$u = $stmt->fetch(PDO::FETCH_ASSOC);

// 3. Authentifizierung & Ablaufprüfung
if (!$u || $u['password'] !== $pass || time() > $u['expires']) {
    echo json_encode([
        "user_info" => [
            "auth" => 0,
            "status" => "Active",
            "exp_date" => "0",
            "message" => "Zugang verweigert oder abgelaufen"
        ]
    ]);
    exit;
}

// 4. IP-Limit Prüfung
$ip = $_SERVER['REMOTE_ADDR'];
$ipfile = "/tmp/ips_" . $user . ".json";
$ips = file_exists($ipfile) ? json_decode(file_get_contents($ipfile), true) : [];

if (!in_array($ip, $ips)) {
    if (count($ips) >= $u['max_ips']) {
        echo json_encode(["user_info" => ["auth" => 0, "message" => "Max Connections reached"]]);
        exit;
    }
    $ips[] = $ip;
    file_put_contents($ipfile, json_encode($ips));
}

// 5. DETAILLIERTES LOGGING (Für das Dashboard Pop-up)
$logfile = "/tmp/logs_" . $user . ".json";
$logs = file_exists($logfile) ? json_decode(file_get_contents($logfile), true) : [];

$newLog = [
    "time" => date("d.m.Y H:i:s"),
    "ip" => $ip,
    "ua" => $_SERVER['HTTP_USER_AGENT'] ?? 'Unknown Player',
    "action" => $action,
    "stream_id" => $_GET['stream_id'] ?? ($_GET['series_id'] ?? ($_GET['vod_id'] ?? 'N/A'))
];

array_unshift($logs, $newLog); // Neueste oben
$logs = array_slice($logs, 0, 50); // Behalte nur die letzten 50 Einträge
file_put_contents($logfile, json_encode($logs));

// 6. XTREAM API ANTWORTEN (Simulation/Proxy)
// Wenn dein Dashboard als Proxy fungiert, leiten wir hier die echten Daten weiter
// oder senden die Benutzer-Informationen zurück.

$userInfo = [
    "auth" => 1,
    "username" => $u['username'],
    "password" => $u['password'],
    "exp_date" => $u['expires'],
    "is_trial" => "0",
    "active_cons" => count($ips),
    "max_connections" => $u['max_ips'],
    "allowed_output_formats" => ["m3u8", "ts", "mkv"]
];

// Falls nur Login-Daten abgefragt werden
if ($action == 'login' || empty($action)) {
    echo json_encode([
        "user_info" => $userInfo,
        "server_info" => [
            "url" => $_SERVER['HTTP_HOST'],
            "port" => "80",
            "server_protocol" => "http",
            "rtmp_port" => "80",
            "timezone" => "Europe/Berlin",
            "time_now" => date("Y-m-d H:i:s")
        ]
    ]);
    exit;
}

// 7. WEITERLEITUNG / PROXY LOGIK
// Hier holt das Skript normalerweise die Kategorien/Streams vom Hauptserver
// Da du eine lokale master_playlist.m3u hast, müsste hier ein Parser für Xtream-Anfragen hin.
// Für den Moment geben wir leere Listen zurück, damit der Player nicht abstürzt:

echo json_encode([]); 
exit;

