<?php
// KEIN Leerzeichen vor diesem Tag!
error_reporting(0);
ini_set('display_errors', 0);

$db_file = "db.sqlite";
$m3u_file = "master_playlist.m3u";

$u = $_GET['username'] ?? $_GET['u'] ?? '';
$p = $_GET['password'] ?? $_GET['p'] ?? '';

try {
    $db = new PDO("sqlite:$db_file");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // User suchen
    $stmt = $db->prepare("SELECT * FROM users WHERE username = ? AND password = ?");
    $stmt->execute([$u, $p]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
} catch (Exception $e) { exit; }

// --- ZEITLIMIT PRÜFUNG ---
if (!$user) {
    header('HTTP/1.1 403 Forbidden');
    die("ZUGANG_NICHT_GEFUNDEN");
}

$jetzt = time();
$ablauf = (int)$user['expires'];

// WICHTIG: Vergleich der Timestamps
if ($jetzt > $ablauf) {
    header('HTTP/1.1 403 Forbidden');
    // Wir geben eine klare Meldung aus, die du im Browser sehen kannst
    die("LIMIT_ERR: Account abgelaufen am " . date("d.m.Y H:i", $ablauf));
}

if ($user['active'] == 0) {
    header('HTTP/1.1 403 Forbidden');
    die("ACCOUNT_DEAKTIVIERT");
}

// --- HEADER FÜR TIVIMATE ---
// Wir nutzen "audio/mpegurl", das ist der Goldstandard für TV-Apps
header('Content-Type: audio/mpegurl');
header('Content-Disposition: inline; filename="playlist.m3u"');

// --- PLAYLIST AUSGABE ---
if (file_exists($m3u_file)) {
    $allowed_cats = explode(",", $user['categories']);
    $all_allowed = ($user['categories'] === "*" || empty($user['categories']));
    
    // Wir öffnen die Datei im Lese-Modus
    $handle = fopen($m3u_file, "r");
    
    // BOM (unsichtbare Zeichen) entfernen und EXTM3U sauber starten
    echo "#EXTM3U" . PHP_EOL;

    while (($line = fgets($handle)) !== false) {
        if (strpos($line, '#EXTINF') === 0) {
            $url = fgets($handle);
            
            // Kategorie filtern
            preg_match('/group-title="([^"]+)"/i', $line, $match);
            $cat = $match[1] ?? 'Unkategorisiert';

            if ($all_allowed || in_array($cat, $allowed_cats)) {
                echo trim($line) . PHP_EOL;
                echo trim($url) . PHP_EOL;
            }
        }
    }
    fclose($handle);
}

