<?php
header('Content-Type: application/json');
$db = new PDO("sqlite:db.sqlite");

$user = $_GET['username'] ?? '';
$pass = $_GET['password'] ?? '';

// 1️⃣ Benutzer aus DB laden
$stmt = $db->prepare("SELECT * FROM users WHERE username=?");
$stmt->execute([$user]);
$u = $stmt->fetch(PDO::FETCH_ASSOC);

// 2️⃣ **Strenge Prüfung**
if(!$u){ // Username existiert nicht
    echo json_encode(["user_info"=>["auth"=>0]]);
    exit;
}

if($u['password'] !== $pass){ // Passwort falsch
    echo json_encode(["user_info"=>["auth"=>0]]);
    exit;
}

if(time() > $u['expires']){ // Account abgelaufen
    echo json_encode(["user_info"=>["auth"=>0]]);
    exit;
}

// 3️⃣ IP-Limit prüfen
$ip = $_SERVER['REMOTE_ADDR'];
$ipfile = "/tmp/ips_".$user.".json";
$ips = file_exists($ipfile) ? json_decode(file_get_contents($ipfile), true) : [];

if(!in_array($ip,$ips)){
    if(count($ips) >= $u['max_ips']){
        echo json_encode(["user_info"=>["auth"=>0]]);
        exit;
    }
    $ips[] = $ip;
    file_put_contents($ipfile,json_encode($ips));
}

// 4️⃣ Log speichern
$logfile = "/tmp/logs_".$user.".json";
$logs = file_exists($logfile) ? json_decode(file_get_contents($logfile), true) : [];
$logs[] = [
    'time' => date('Y-m-d H:i:s'),
    'ip' => $ip,
    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? ''
];
file_put_contents($logfile,json_encode($logs));

// 5️⃣ Auth ok
echo json_encode([
    "user_info"=>[
        "auth"=>1,
        "username"=>$user,
        "password"=>$pass,
        "exp_date"=>$u['expires'],
        "max_connections"=>$u['max_ips']
    ]
]);
