<?php
$db = new PDO("sqlite:db.sqlite");

// Funktionen: Löschen, Logs löschen
if(isset($_GET['delete_user'])){
    $stmt = $db->prepare("DELETE FROM users WHERE username=?");
    $stmt->execute([$_GET['delete_user']]);
    @unlink("/tmp/logs_".$_GET['delete_user'].".json");
    @unlink("/tmp/ips_".$_GET['delete_user'].".json");
    header("Location: admin.php"); exit;
}

if(isset($_GET['clear_logs'])){
    @unlink("/tmp/logs_".$_GET['clear_logs'].".json");
    header("Location: admin.php"); exit;
}

// User erstellen / bearbeiten
if($_POST){
    $stmt = $db->prepare("REPLACE INTO users VALUES (?,?,?,?)");
    $stmt->execute([
        $_POST['u'],
        $_POST['p'],
        time() + ($_POST['h']*3600),
        $_POST['i']
    ]);
    header("Location: admin.php"); exit;
}

$users = $db->query("SELECT * FROM users")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="de">
<head>
<meta charset="UTF-8">
<title>IPTV Ultimate Dashboard</title>
<style>
body{font-family:Arial;background:#f4f4f9;padding:20px;color:#333;}
h2,h3{color:#2c3e50;}
table{width:100%;border-collapse:collapse;margin-top:20px;}
th,td{border:1px solid #ccc;padding:8px;text-align:left;}
th{background:#2c3e50;color:white;}
tr:nth-child(even){background:#ecf0f1;}
tr.expired{background:#f9caca;}
input,button{padding:5px;margin:5px 0;}
button{background:#3498db;color:white;border:none;cursor:pointer;}
button:hover{background:#2980b9;}
a{color:#3498db;text-decoration:none;}
a:hover{text-decoration:underline;}
.log{font-size:0.85em;color:#555;background:#ecf0f1;padding:5px;margin:2px 0;border-radius:3px;}
</style>
</head>
<body>

<h2>IPTV Ultimate Dashboard</h2>

<h3>Neuen User erstellen / bearbeiten</h3>
<form method="post">
Username:<br><input name="u" required><br>
Password:<br><input name="p" required><br>
Gültig (Stunden):<br><input name="h" value="24" required><br>
Max IPs:<br><input name="i" value="2" required><br>
<button>Speichern</button>
</form>

<h3>Alle User</h3>
<table>
<tr>
<th>Username</th>
<th>Password</th>
<th>Ablaufzeit</th>
<th>Max IPs</th>
<th>Logs</th>
<th>Aktionen</th>
</tr>
<?php foreach($users as $u): 
$logfile = "/tmp/logs_".$u['username'].".json";
$logs = file_exists($logfile) ? json_decode(file_get_contents($logfile), true) : [];
$expired = time() > $u['expires'];
?>
<tr class="<?=$expired?'expired':''?>">
<td><?=htmlspecialchars($u['username'])?></td>
<td><?=htmlspecialchars($u['password'])?></td>
<td><?=date("Y-m-d H:i:s",$u['expires'])?></td>
<td><?=$u['max_ips']?></td>
<td>
<?php foreach($logs as $l): ?>
<div class="log"><?=htmlspecialchars($l['time']." | ".$l['ip']." | ".$l['user_agent'])?></div>
<?php endforeach; ?>
</td>
<td>
<a href="admin.php?delete_user=<?=urlencode($u['username'])?>" onclick="return confirm('User löschen?')">Löschen</a> |
<a href="admin.php?clear_logs=<?=urlencode($u['username'])?>" onclick="return confirm('Logs löschen?')">Logs leeren</a>
</td>
</tr>
<?php endforeach; ?>
</table>

</body>
</html>
